#include <stdio.h>
#include <stdlib.h>

#define uint unsigned int

// #define DEBUG

typedef struct {
  uint pocetnaPozicija;
  uint trenutnaPozicija;
  uint brzina;
  uint sledecaPozicija;
  double presretanje;
} Trkac;

int main (void)
{
  uint N; // broj ucesnika
  uint K; // broj presretanja
  uint sec = 0;
  uint presretanje = 0;

  // unos sa konzole - <N - broj trkaca> <K - broj presretanja>
  #ifdef DEBUG
    printf("Unesi <broj trkaca> i <broj presretanja>\n");
  #endif
  scanf("%d%d", &N , &K);

  Trkac* trkaci = calloc(N, sizeof(*trkaci));
  #ifdef DEBUG
    printf("Rezervisana memorija = %d\n\n", N * sizeof(*trkaci));
  #endif

  // unos sa konzole
  for (uint i=0; i<N; i++)
  {
    #ifdef DEBUG
      printf("Unesi <trenutnu poziciju> i <brzinu> trkaca %d\n", i+1);
    #endif
    scanf("%d%d", &trkaci[i].pocetnaPozicija, &trkaci[i].brzina);
    trkaci[i].trenutnaPozicija = trkaci[i].pocetnaPozicija;
    #ifdef DEBUG
      // stampanje unetih podataka trkaca
      printf("trkac: %d, pozicija: %d, brzina: %d\n", i+1, trkaci[i].pocetnaPozicija, trkaci[i].brzina);
    #endif
  }

  while (presretanje < K)
  {
    // izracun pozicije u sledecoj sekundi za svakog trkaca
    for (uint i=0; i<N; i++)
    {
      trkaci[i].sledecaPozicija = trkaci[i].trenutnaPozicija + trkaci[i].brzina;
    }

    // provera i izracun presretanja trkaca
    for (uint i=0; i<N; i++)
    {
      for (uint j=i+1; j<N; j++)
      {
        int position = (int)trkaci[j].trenutnaPozicija - (int)trkaci[i].trenutnaPozicija;
        int velocity = (int)trkaci[i].brzina - (int)trkaci[j].brzina;
        if (velocity != 0)
        {
          double interception = (double)position / velocity;
          if ((interception > 0) && (interception < 1))
          {
            // presretanje postoji
            trkaci[j].presretanje = (double) sec + interception;
            presretanje++;
          }
          else if (interception == 0)
          {
            // presretanje postoji na samom pocetku
            trkaci[j].presretanje = (double) sec;
            presretanje++;
          }
        }
      }
    }

    // ispis presretanja trkaca
    for (uint i=0; i<N; i++)
    {
      trkaci[i].trenutnaPozicija = trkaci[i].sledecaPozicija;
      if (trkaci[i].presretanje > 0)
      {
        printf("%f\n", trkaci[i].presretanje);
        trkaci[i].presretanje = 0.0F;
      }
    }
    sec++;
  } // end of while

  free(trkaci);
  return 0;
}